/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.anim;

import jpcsp.format.rco.ObjectField;
import jpcsp.format.rco.anim.AbstractAnimAction;
import jpcsp.format.rco.anim.BaseAnim;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.type.FloatType;
import jpcsp.format.rco.type.IntType;
import jpcsp.format.rco.type.ObjectType;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;

public class ResizeAnim
extends BaseAnim {
    @ObjectField(order=1)
    public ObjectType ref;
    @ObjectField(order=2)
    public FloatType duration;
    @ObjectField(order=3)
    public IntType accelMode;
    @ObjectField(order=4)
    public FloatType width;
    @ObjectField(order=5)
    public FloatType height;
    @ObjectField(order=6)
    public FloatType depth;

    @Override
    protected long doPlayReference(BasePositionObject object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("ResizeAnim play %s on %s", this.toString(), object));
        }
        ResizeAnim.getScheduler().addAction(new ResizeAnimAction(this.duration.getIntValue(), object));
        return 0L;
    }

    @Override
    protected long doPlay(VSMXBaseObject object) {
        return this.doPlayReference(this.ref);
    }

    private class ResizeAnimAction
    extends AbstractAnimAction {
        private BasePositionObject positionObject;
        private float startWidth;
        private float startHeight;
        private float startDepth;

        public ResizeAnimAction(int duration, BasePositionObject positionObject) {
            super(duration);
            this.positionObject = positionObject;
            this.startWidth = positionObject.scaleWidth.getFloatValue();
            this.startHeight = positionObject.scaleHeight.getFloatValue();
            this.startDepth = positionObject.scaleDepth.getFloatValue();
        }

        @Override
        protected void anim(float step) {
            this.positionObject.scaleWidth.setFloatValue(this.startWidth + ResizeAnim.this.width.getFloatValue() * step);
            this.positionObject.scaleHeight.setFloatValue(this.startHeight + ResizeAnim.this.height.getFloatValue() * step);
            this.positionObject.scaleDepth.setFloatValue(this.startDepth + ResizeAnim.this.depth.getFloatValue() * step);
            this.positionObject.onDisplayUpdated();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("ResizeAnim '%s' from (%f,%f,%f) to (%f,%f,%f)", this.positionObject.getName(), Float.valueOf(this.startWidth), Float.valueOf(this.startHeight), Float.valueOf(this.startDepth), Float.valueOf(this.positionObject.scaleWidth.getFloatValue()), Float.valueOf(this.positionObject.scaleHeight.getFloatValue()), Float.valueOf(this.positionObject.scaleDepth.getFloatValue())));
            }
        }
    }
}

